﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="ConnectionDropWindow.xaml.cs" company="Palizafzar">
//   Author : Mohammad Habibzadeh
// </copyright>
// <summary>
//   Interaction logic for ConnectionDropWindow.xaml
// </summary>
// --------------------------------------------------------------------------------------------------------------------

namespace PalizTiara.Server
{
    using System;
    using System.Collections.ObjectModel;
    using System.Windows;

    using PalizTiara.Api;
    using PalizTiara.Server.ViewModel;

    /// <summary>
    /// Interaction logic for ConnectionDropWindow.xaml
    /// </summary>
    public partial class ConnectionDropWindow
    {
        private readonly TiaraServerManager serverManager;
        private readonly ObservableCollection<DeviceListBoxModel> deviceList = new ObservableCollection<DeviceListBoxModel>();

        public ConnectionDropWindow(TiaraServerManager serverManager)
        {
            this.InitializeComponent();
            this.serverManager = serverManager;
            this.DeviceListBox.ItemsSource = this.deviceList;
        }

        private async void CloseConnectionButton_OnClick(object sender, RoutedEventArgs e)
        {
            foreach (var device in this.deviceList)
            {
                if (device.IsChecked)
                {
                    await this.serverManager.CloseTerminalAsyncTask(device.Name);
                }
            }
        }

        private async void DeviceListBox_OnLoaded(object sender, RoutedEventArgs e)
        {
            var devices = await this.serverManager.GetStatusAsyncTask();
            foreach (var device in devices)
            {
                this.deviceList.Add(new DeviceListBoxModel(device.TerminalName, false));
            }
        }
    }
}
