﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="BinaryArrayConverter.cs" company="Palizafzar">
//   Author : Mohammad Habibzadeh
// </copyright>
// <summary>
//   Defines the BinaryArrayConverter type.
// </summary>
// --------------------------------------------------------------------------------------------------------------------

namespace PalizTiara.Server.Converters
{
    using System;
    using System.Globalization;
    using System.Windows.Data;

    public class BinaryArrayConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            var bytes = value as byte[];
            if (bytes == null || bytes.Length == 0)
            {
                return string.Empty;
            }
            else
            {
                return $"{bytes.Length}";
            }
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}