// --------------------------------------------------------------------------------------------------------------------
// <copyright file="CardConverter.cs" company="Palizafzar">
//   Author : Mohammad Habibzadeh
// </copyright>
// --------------------------------------------------------------------------------------------------------------------

namespace PalizTiara.Server.Converters
{
    using System;
    using System.Globalization;
    using System.Windows.Data;

    public class CardConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            var cards = value as long[];
            if (cards == null || cards.Length == 0)
            {
                return string.Empty;
            }
            return string.Join(Environment.NewLine, cards);
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}