﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="ClockTypeConverter.cs" company="Palizafzar">
//   Author : Mohammad Habibzadeh
// </copyright>
// <summary>
//   Defines the ClockTypeConverter type.
// </summary>
// --------------------------------------------------------------------------------------------------------------------

namespace PalizTiara.Server.Converters
{
    using System;
    using System.Globalization;
    using System.Windows.Data;

    using PalizTiara.Api.Definition;

    public class ClockTypeConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            var clockType = ClockTypes.DIGITAL;
            try
            {
                clockType = (ClockTypes)value;
            }
            catch (Exception)
            {
                // ignored
            }
            return Enum.GetName(typeof(ClockTypes), clockType);
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            var clockType = ClockTypes.DIGITAL;
            try
            {
                clockType = (ClockTypes)Enum.Parse(typeof(ClockTypes), value as string);
            }
            catch (Exception)
            {
                // ignored
            }
            return (int)clockType;
        }
    }
}