﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="DateTypeConverter.cs" company="Palizafzar">
//   Author : Mohammad Habibzadeh
// </copyright>
// <summary>
//   Defines the DateTypeConverter type.
// </summary>
// --------------------------------------------------------------------------------------------------------------------

namespace PalizTiara.Server.Converters
{
    using System;
    using System.Globalization;
    using System.Windows.Data;

    using PalizTiara.Api.Definition;

    public class DateTypeConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            var dateType = DateTypes.PersianCalendar;
            try
            {
                dateType = (DateTypes)value;
            }
            catch (Exception)
            {
                // ignored
            }
            return Enum.GetName(typeof(DateTypes), dateType);
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            var dateType = DateTypes.PersianCalendar;
            try
            {
                dateType = (DateTypes)Enum.Parse(typeof(DateTypes), (string)value);
            }
            catch (Exception)
            {
                // ignored
            }
            return (int)dateType;
        }
    }
}