// --------------------------------------------------------------------------------------------------------------------
// <copyright file="FingerprintConverter.cs" company="Palizafzar">
//   Author : Mohammad Habibzadeh
// </copyright>
// --------------------------------------------------------------------------------------------------------------------

namespace PalizTiara.Server.Converters
{
    using System;
    using System.Globalization;
    using System.Windows.Data;

    using PalizTiara.Api.Models;

    public class FingerprintConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            var fingers = value as FingerprintModel[];
            if (fingers == null || fingers.Length == 0)
            {
                return string.Empty;
            }
            else
            {
                return $"{fingers.Length}";
            }
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}