﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="TrafficTypeConverter.cs" company="Palizafzar">
//   Author : Mohammad Habibzadeh
// </copyright>
// --------------------------------------------------------------------------------------------------------------------

namespace PalizTiara.Server.Converters
{
    using System;
    using System.Globalization;
    using System.Windows.Data;

    using Api.Helpers;

    public class TrafficTypeConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            long trafficId = 0;
            try
            {
                trafficId = (long)value;
            }
            catch (Exception)
            {
            }
            if (trafficId > 0)
            {
                return StaticHelpers.GetTrafficName(trafficId);
            }
            return string.Empty;
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}