﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="VerificationDeviceConverter.cs" company="Palizafzar">
//   Author : Mohammad Habibzadeh
// </copyright>
// --------------------------------------------------------------------------------------------------------------------

namespace PalizTiara.Server.Converters
{
    using System;
    using System.Globalization;
    using System.Windows.Data;

    using Api.Helpers;

    public class VerificationDeviceConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            var devices = value as string;
            return string.IsNullOrEmpty(devices) ? string.Empty : StaticHelpers.GetDeviceNames(devices);
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}