﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="VerificationTypeIdConverter.cs" company="Palizafzar">
//   Author : Mohammad Habibzadeh
// </copyright>
// <summary>
//   Defines the VerificationTypeIdConverter type.
// </summary>
// --------------------------------------------------------------------------------------------------------------------

namespace PalizTiara.Server.Converters
{
    using System;
    using System.Globalization;
    using System.Windows.Data;

    using Api.Helpers;

    public class VerificationTypeIdConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            var id = (long)value;
            return StaticHelpers.GetVerificationType(id);
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}