﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="DeviceDateTimeInfoWindow.xaml.cs" company="Palizafzar">
//   Author : Mohammad Habibzadeh
// </copyright>
// <summary>
//   Interaction logic for DeviceDateTimeInfoWindow.xaml
// </summary>
// --------------------------------------------------------------------------------------------------------------------

namespace PalizTiara.Server
{
    using System;
    using System.Collections.ObjectModel;
    using System.Diagnostics;

    using PalizTiara.Api;
    using PalizTiara.Api.CallBacks;
    using PalizTiara.Api.Models;
    using PalizTiara.Server.ViewModel;

    /// <summary>
    /// Interaction logic for DeviceDateTimeInfoWindow.xaml
    /// </summary>
    public partial class DeviceDateTimeInfoWindow
    {
        private readonly TiaraServerManager serverManager;

        private readonly ObservableCollection<DeviceDateTimeInfoViewModel> deviceDateTimeInfoCollection =
            new ObservableCollection<DeviceDateTimeInfoViewModel>();

        public DeviceDateTimeInfoWindow(TiaraServerManager serverManager)
        {
            this.InitializeComponent();
            this.serverManager = serverManager;
            this.DeviceDateTimeInfoDataGrid.ItemsSource = this.deviceDateTimeInfoCollection;
            this.serverManager.GetDateTimeInfoEvent += this.ServerManagerOnGetDateTimeInfoEvent;           
        }

        protected override async void OnSourceInitialized(EventArgs e)
        {
            var deviceStatuses = await this.serverManager.GetStatusAsyncTask();
            foreach (var device in deviceStatuses)
            {
                if (device.IsOnline)
                {
                    await this.serverManager.GetDateTimeInfoAsyncTask(device.TerminalName);
                }
            }
            base.OnSourceInitialized(e);
        }

        protected override void OnClosed(EventArgs e)
        {
            this.serverManager.GetDateTimeInfoEvent -= this.ServerManagerOnGetDateTimeInfoEvent;
            base.OnClosed(e);
        }

        private void ServerManagerOnGetDateTimeInfoEvent(object sender, DeviceDateTimeInfoEventArgs args)
        {
            var deviceSender = (DeviceSender)sender;            
            if (string.IsNullOrEmpty(deviceSender?.TerminalName))
            {
                return;
            }
            if (args?.DeviceDateTimeInfoModel?.DateModel == null || args.DeviceDateTimeInfoModel.ClockTypeModel == null || args.DeviceDateTimeInfoModel.DateTypeModel == null)
            {
                return;
            }
            this.DeviceDateTimeInfoDataGrid.Dispatcher.Invoke(
                () =>
                    {
                        this.deviceDateTimeInfoCollection.Add(
                            new DeviceDateTimeInfoViewModel(
                                deviceSender.TerminalName,
                                args.DeviceDateTimeInfoModel.DateModel.Date,
                                args.DeviceDateTimeInfoModel.DateTypeModel.GetDateType(),
                                args.DeviceDateTimeInfoModel.ClockTypeModel.GetClockType(),
                                args.DeviceDateTimeInfoModel.TimeZoneModel.TimeZone));
                    });
        }
    }
}
