﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="DeviceInfoWindow.xaml.cs" company="Palizafzar">
//   Author : Mohammad Habibzadeh
// </copyright>
// --------------------------------------------------------------------------------------------------------------------

namespace PalizTiara.Server
{
    using System;

    using System.Collections.ObjectModel;
    using System.Windows;

    using Api;

    using Api.CallBacks;

    using Api.Models;

    /// <summary>
    /// Device Information Window
    /// </summary>
    public partial class DeviceInfoWindow
    {
        private readonly TiaraServerManager serverManager;
        private readonly ObservableCollection<DeviceInfoModel> deviceInfoList = new ObservableCollection<DeviceInfoModel>();

        public DeviceInfoWindow(TiaraServerManager serverManager)
        {
            this.InitializeComponent();
            this.DeviceInfoDataGrid.ItemsSource = this.deviceInfoList;
            this.serverManager = serverManager;
            this.serverManager.RemoteAuthCardVerifyEvent += ServerManager_RemoteAuthCardVerifyEvent;
            this.serverManager.RemoteAuthUserInfoRequestEvent += ServerManager_RemoteAuthUserInfoRequestEvent; ;
        }

        private void ServerManager_RemoteAuthUserInfoRequestEvent(object sender, UserActionEventArgs args)
        {
            this.serverManager.RemoteAuthUserInformationAsyncTask(args.TerminalName, new RemoteAuthUserInfoModel(15, "hassan YYY", null, (long)10, 2, false, false, false, 0), true);
        }
        private void ServerManager_RemoteAuthCardVerifyEvent(object sender, RemoteAuthRequestEventArgs args)
        {
            this.serverManager.RemoteAuthCardVerifyAsyncTask(args.TerminalName, new RemoteAuthResponseContainer(15,true));
        }

        protected override void OnClosed(EventArgs e)
        {
            this.serverManager.DeviceInfoEvent -= this.ServerManagerOnDeviceInfoEvent;
            this.serverManager.DeviceConnectionClosedEvent -= this.ServerManagerOnDeviceConnectionClosedEvent;
            base.OnClosed(e);
        }

        private void ServerManagerOnDeviceConnectionClosedEvent(object sender)
        {            
            this.DeviceInfoDataGrid.Dispatcher.Invoke(() =>
            {
                this.deviceInfoList.Add(new DeviceInfoModel(sender as string, false));
            });
        }

        private void ServerManagerOnDeviceInfoEvent(object sender, DeviceInfoEventArgs args)
        {
            this.DeviceInfoDataGrid.Dispatcher.Invoke(() =>
            {
                this.deviceInfoList.Add(args.DeviceInfo);
            });
        }

        private void DeviceInfoDataGrid_OnLoaded(object sender, RoutedEventArgs e)
        {
            this.serverManager.DeviceInfoEvent += this.ServerManagerOnDeviceInfoEvent;
            this.serverManager.DeviceConnectionClosedEvent += this.ServerManagerOnDeviceConnectionClosedEvent;
        }
    }
}
