﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="DeviceListWindow.xaml.cs" company="Palizafzar">
//   Author : Mohammad Habibzadeh
// </copyright>
// --------------------------------------------------------------------------------------------------------------------

namespace PalizTiara.Server
{
    using System.Windows;

    using Api;

    /// <summary>
    /// Connected Device List Window
    /// </summary>
    public partial class DeviceListWindow
    {
        private readonly TiaraServerManager serverManager;

        public DeviceListWindow(TiaraServerManager serverManager)
        {
            this.InitializeComponent();
            this.serverManager = serverManager;
        }

        private async void DeviceListDockPanel_OnLoaded(object sender, RoutedEventArgs e)
        {
            var deviceStatuses = await this.serverManager.GetStatusAsyncTask();
            this.DeviceListDataGrid.ItemsSource = deviceStatuses;
        }
    }
}
