﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="DeviceStorageInfoWindow.xaml.cs" company="Palizafzar">
//   Author : Mohammad Habibzadeh
// </copyright>
// <summary>
//   Interaction logic for DeviceStorageInfoWindow.xaml
// </summary>
// --------------------------------------------------------------------------------------------------------------------
namespace PalizTiara.Server
{
    using System;
    using System.Collections.ObjectModel;
    using System.Windows;

    using PalizTiara.Api;
    using PalizTiara.Api.CallBacks;
    using PalizTiara.Api.Models;
    using PalizTiara.Server.ViewModel;

    /// <summary>
    /// Interaction logic for DeviceStorageInfoWindow.xaml
    /// </summary>
    public partial class DeviceStorageInfoWindow
    {
        private readonly TiaraServerManager serverManager;

        private readonly ObservableCollection<DeviceStorageViewModel> storageCollection =
            new ObservableCollection<DeviceStorageViewModel>();

        public DeviceStorageInfoWindow(TiaraServerManager serverManager)
        {
            this.InitializeComponent();
            this.serverManager = serverManager;
            this.DeviceStorageDataGrid.ItemsSource = this.storageCollection;
        }

        protected override async void OnSourceInitialized(EventArgs e)
        {
            this.serverManager.StorageInfoEvent += this.ServerManagerOnStorageInfoEvent;
            var deviceStatuses = await this.serverManager.GetStatusAsyncTask();
            foreach (var device in deviceStatuses)
            {
                if (device.IsOnline)
                {
                    await this.serverManager.GetStorageInfoAsyncTask(device.TerminalName);
                }
            }
            base.OnSourceInitialized(e);
        }

        protected override void OnClosed(EventArgs e)
        {
            this.serverManager.StorageInfoEvent -= this.ServerManagerOnStorageInfoEvent;
            base.OnClosed(e);
        }

        private void ServerManagerOnStorageInfoEvent(object sender, DeviceStorageInfoEventArgs args)
        {
            var deviceSender = (DeviceSender)sender;
            if (string.IsNullOrEmpty(deviceSender?.TerminalName))
            {
                return;
            }
            if (args?.DeviceStorageModel == null)
            {
                return;
            }
            var info = args.DeviceStorageModel;
            var storage = new DeviceStorageViewModel
                              {
                                  Terminal = deviceSender.TerminalName,
                                  TotalDatabaseFreeSpace = info.TotalDatabaseFreeSpace,
                                  TotalDatabaseSpace = info.TotalDatabaseSpace,
                                  TotalDatabaseUsedSpace = info.TotalDatabaseUsedSpace,
                                  TotalDeviceLogs = info.TotalDeviceLogs,
                                  TotalErrorLogs = info.TotalErrorLogs,
                                  TotalFingers = info.TotalFingers,
                                  TotalFaces = info.TotalFaces,
                                  TotalTrafficLogs = info.TotalTrafficLogs,
                                  TotalRemainedTrafficLogs = info.TotalRemainedTrafficLogs,
                                  TotalUsers = info.TotalUsers
                              };
            this.DeviceStorageDataGrid.Dispatcher.Invoke(
                () =>
                    {
                        this.storageCollection.Add(storage);
                    });
        }
    }
}
