﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="DeviceUpdateWindow.xaml.cs" company="Palizafzar">
//   Author : Mohammad Habibzadeh
// </copyright>
// --------------------------------------------------------------------------------------------------------------------

namespace PalizTiara.Server
{
    using System;
    using System.Collections.ObjectModel;
    using System.Windows;

    using Api;

    using Api.CallBacks;
    using Api.Models;

    using ViewModel;

    /// <summary>
    /// Interaction logic for DeviceUpdateWindow.xaml
    /// </summary>
    public partial class DeviceUpdateWindow
    {
        private const string UpdateFile = @"D:\Tiara.pgp";
        private const string KernelUpdateFile = @"D:\zImage.pgp";
        private readonly TiaraServerManager serverManager;
        private readonly ObservableCollection<DeviceVersionListBoxModel> viewModel = new ObservableCollection<DeviceVersionListBoxModel>();

        public DeviceUpdateWindow(TiaraServerManager serverManager)
        {
            this.InitializeComponent();
            this.serverManager = serverManager;
            this.DeviceListBox.ItemsSource = this.viewModel;
            this.serverManager.VersionInfoEvent += this.ServerManagerOnVersionInfoEvent;
            this.serverManager.UpdateResultEvent += this.ServerManagerOnUpdateResultEvent;
        }

        protected override void OnClosed(EventArgs e)
        {
            this.serverManager.VersionInfoEvent -= this.ServerManagerOnVersionInfoEvent;
            this.serverManager.UpdateResultEvent -= this.ServerManagerOnUpdateResultEvent;
            base.OnClosed(e);
        }

        private void ServerManagerOnUpdateResultEvent(object sender, SetActionEventArgs args)
        {
            this.LogTextBlock.Dispatcher.Invoke(
                () =>
                    {
                        this.LogTextBlock.Text += $"{args.TerminalName} Update Result : {args.Result}{Environment.NewLine}";
                    });
        }

        private void ServerManagerOnVersionInfoEvent(object sender, VersionInfoEventArgs args)
        {
            if (args == null || !args.Result)
            {
                return;                
            }
            var device = (DeviceSender)sender;
            this.DeviceListBox.Dispatcher.Invoke(
                () =>
                    {
                        this.viewModel.Add(new DeviceVersionListBoxModel(device.TerminalName, args.VersionInfoModel.SoftwareVersionName, false));
                    });
        }

        private async void DeviceListBox_OnLoaded(object sender, RoutedEventArgs e)
        {
            var devices = await this.serverManager.GetStatusAsyncTask();
            foreach (var device in devices)
            {
                if (device.IsOnline)
                {
                    await this.serverManager.GetVersionInfoAsyncTask(device.TerminalName);
                }
            }
        }

        private async void Update_OnClick(object sender, RoutedEventArgs e)
        {
            foreach (var device in this.viewModel)
            {
                if (device.IsChecked)
                {
                    await this.serverManager.UpdateSoftwareAsyncTask(device.Name, UpdateFile, this.UploadProgressHandler);
                }
            }
        }

        private void UploadProgressHandler(object sender, ProgressInfoEventArgs args)
        {
            if (args == null)
            {
                return;
            }
            this.LogTextBlock.Dispatcher.Invoke(
                () =>
                    {
                        this.LogTextBlock.Text +=
                            $"{DateTime.Now} :: Upload To Device: {args.TerminalName}, Percent: %{args.Percent}{Environment.NewLine}";
                    });
        }

        private async void UpdateKernel_OnClick(object sender, RoutedEventArgs e)
        {
            foreach (var device in this.viewModel)
            {
                if (device.IsChecked)
                {
                    await this.serverManager.UpdateKernelAsyncTask(device.Name, KernelUpdateFile, this.UploadProgressHandler);
                }
            }
        }
    }
}
