﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="MainWindow.xaml.cs" company="Palizafzar">
//   Author : Mohammad Habibzadeh
// </copyright>
// --------------------------------------------------------------------------------------------------------------------

namespace PalizTiara.Server
{
    using System;
    using System.Windows;
    using Api;
    using Protocol.Utility;

    /// <summary>
    /// Main Application Window
    /// </summary>
    public partial class MainWindow
    {
        private readonly TiaraServerManager serverManager;

        public MainWindow()
        {
            this.InitializeComponent();
            Trace.TraceLevel = TraceLevel.Error;
            TextBlockTraceListener traceListener = new TextBlockTraceListener(this.ServerOutputTextBlock);

            // Trace.TraceListener = (f, a) => System.Diagnostics.Trace.WriteLine(String.Format(f, a));
            Trace.TraceListener = (f, a) => traceListener.WriteLine(string.Format(f, a));
            TiaraServerManager.Bootstrapper();
            this.serverManager = new TiaraServerManager();
        }

        protected override void OnClosed(EventArgs e)
        {
            base.OnClosed(e);
            this.serverManager.Stop();
        }

        private void StartServerMenuItem_OnClick(object sender, RoutedEventArgs e)
        {
            Trace.WriteLine(TraceLevel.Verbose, "Server Started!");
            this.serverManager.Start();
        }

        private void StopServerMenuItem_OnClick(object sender, RoutedEventArgs e)
        {
            Trace.WriteLine(TraceLevel.Verbose, "Server Stopped.");
            this.serverManager.Stop();
        }

        private void ExitMenuItem_OnClick(object sender, RoutedEventArgs e)
        {
            Environment.Exit(0);
        }

        private void ClearMenuItem_OnClick(object sender, RoutedEventArgs e)
        {
            this.ServerOutputTextBlock.Text = string.Empty;
        }

        private void DeviceListMenuItem_OnClick(object sender, RoutedEventArgs e)
        {
            var deviceListWindow = new DeviceListWindow(this.serverManager);
            deviceListWindow.Show();
        }

        private void LiveTrafficMenuItem_OnClick(object sender, RoutedEventArgs e)
        {
            var liveTraffic = new LiveTrafficWindow(this.serverManager);
            liveTraffic.Show();
        }

        private void DeviceInfoMenuItem_OnClick(object sender, RoutedEventArgs e)
        {
            var deviceInfoWindow = new DeviceInfoWindow(this.serverManager);
            deviceInfoWindow.Show();
        }

        private void DateTimeSettingMenuItem_OnClick(object sender, RoutedEventArgs e)
        {
            var dateTimeWindow = new DateTimeWindow(this.serverManager);
            dateTimeWindow.Show();
        }

        private void UserInfoMenuItem_OnClick(object sender, RoutedEventArgs e)
        {
            var userInfoWindow = new UserInfoWindow(this.serverManager);
            userInfoWindow.Show();
        }

        private void UserInfoCopier_OnClick(object sender, RoutedEventArgs e)
        {
            var userInfoCopierWindow = new UserInfoCopyWindow(this.serverManager);
            userInfoCopierWindow.Show();
        }

        private void TrafficLogMenuItem_OnClick(object sender, RoutedEventArgs e)
        {
            var trafficLogWindow = new TrafficLogWindow(this.serverManager);
            trafficLogWindow.Show();
        }

        private void DeviceUpdate_OnClick(object sender, RoutedEventArgs e)
        {
            var updateWindow = new DeviceUpdateWindow(this.serverManager);
            updateWindow.Show();
        }

        private void MessageSetting_OnClick(object sender, RoutedEventArgs e)
        {
            var messageWindow = new MessageSettingWindow(this.serverManager);
            messageWindow.Show();
        }

        private void DeviceLogMenuItem_OnClick(object sender, RoutedEventArgs e)
        {
            var deviceLogWindow = new DeviceLogWindow(this.serverManager);
            deviceLogWindow.Show();
        }

        private void DeviceSerial_OnClick(object sender, RoutedEventArgs e)
        {
            var deviceSerialWindow = new DeviceSerialWindow(this.serverManager);
            deviceSerialWindow.Show();
        }

        private void DeviceDateTimeInfo_OnClick(object sender, RoutedEventArgs e)
        {
            var dateTimeInfoWindow = new DeviceDateTimeInfoWindow(this.serverManager);
            dateTimeInfoWindow.Show();
        }

        private void DeviceStorage_OnClick(object sender, RoutedEventArgs e)
        {
            var deviceStorageWindow = new DeviceStorageInfoWindow(this.serverManager);
            deviceStorageWindow.Show();
        }

        private void MassUserInfoCopier_OnClick(object sender, RoutedEventArgs e)
        {
            var massUserInfoWindow = new MassUserInfoCopyWindow(this.serverManager);
            massUserInfoWindow.Show();
        }

        private void SyncTrafficLogMenuItem_OnClick(object sender, RoutedEventArgs e)
        {
            var sync = new RemainedTrafficLogWindow(this.serverManager);
            sync.Show();
        }

        private void RemoteAuthentication_OnClick(object sender, RoutedEventArgs e)
        {
            var remoteAuth = new RemoteAuthWindow(this.serverManager);
            remoteAuth.Show();
        }

        private void RemoteHardware_OnClick(object sender, RoutedEventArgs e)
        {
            var remoteHardware = new RemoteHardwareWindow(this.serverManager);
            remoteHardware.Show();
        }

        private void UserInfoSummaryMenuItem_OnClick(object sender, RoutedEventArgs e)
        {
            var userInfoSummaryWindow = new UserInfoSummaryWindow(this.serverManager);
            userInfoSummaryWindow.Show();
        }

        private void FailedLogMenuItem_OnClick(object sender, RoutedEventArgs e)
        {
            var failedLogWindow = new FailLogWindow(this.serverManager);
            failedLogWindow.Show();
        }

        private void DropConnection_OnClick(object sender, RoutedEventArgs e)
        {
            var dropConnectionWindow = new ConnectionDropWindow(this.serverManager);
            dropConnectionWindow.Show();
        }

        private void SyncFailLogMenuItem_OnClick(object sender, RoutedEventArgs e)
        {
            var remainedFailLog = new RemainedFailLogWindow(this.serverManager);
            remainedFailLog.Show();
        }

        private void DeviceSettings_OnClick(object sender, RoutedEventArgs e)
        {
            var deviceSettingsWindow = new DeviceSettingsWindow(this.serverManager);
            deviceSettingsWindow.Show();
        }
    }
}
