﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="MessageSettingWindow.xaml.cs" company="Palizafzar">
//   Author : Mohammad Habibzadeh
// </copyright>
// --------------------------------------------------------------------------------------------------------------------

namespace PalizTiara.Server
{
    using System;
    using System.Collections.ObjectModel;
    using System.Windows;
    using System.Windows.Media;

    using Api;
    using Api.Models;

    using PalizTiara.Api.CallBacks;

    using ViewModel;

    /// <summary>
    /// The message setting window.
    /// </summary>
    public partial class MessageSettingWindow
    {
        private readonly TiaraServerManager serverManager;
        private readonly ObservableCollection<DeviceListBoxModel> deviceList = new ObservableCollection<DeviceListBoxModel>();

        public MessageSettingWindow(TiaraServerManager serverManager)
        {
            this.InitializeComponent();
            this.serverManager = serverManager;
            this.DeviceListBox.ItemsSource = this.deviceList;
            this.serverManager.SetMessageEvent += this.ServerManagerOnSetMessageEvent;
        }

        protected override void OnClosed(EventArgs e)
        {
            this.serverManager.SetMessageEvent += this.ServerManagerOnSetMessageEvent;
            base.OnClosed(e);
        }

        private void ServerManagerOnSetMessageEvent(object sender, SetActionEventArgs args)
        {
            if (args.Result)
            {
                this.StatusTextBlock.Dispatcher.Invoke(
                    () =>
                        {
                            this.StatusTextBlock.Text = "Message Saved.";
                            this.StatusTextBlock.Foreground = Brushes.Green;
                        });
            }
            else
            {
                this.StatusTextBlock.Dispatcher.Invoke(
                    () =>
                        {
                            this.StatusTextBlock.Text = "Unable To Save Message.";
                            this.StatusTextBlock.Foreground = Brushes.Red;
                        });
            }
        }

        private async void Send_OnClick(object sender, RoutedEventArgs e)
        {
            long[] userIds = null;
            if (!string.IsNullOrEmpty(this.UsersTextBox.Text))
            {
                var ids = this.UsersTextBox.Text.Split(',');
                userIds = new long[ids.Length];
                for (int i = 0; i < ids.Length; i++)
                {
                    try
                    {
                        userIds[i] = long.Parse(ids[i]);
                    }
                    catch (Exception exception)
                    {
                        Console.WriteLine(exception);
                    }
                }
            }
            int display = 0;
            int hidden = 0;
            if (!string.IsNullOrEmpty(this.DisplayDurationTextBox.Text))
            {
                display = int.Parse(this.DisplayDurationTextBox.Text);
            }
            if (!string.IsNullOrEmpty(this.HiddenDurationTextBox.Text))
            {
                hidden = int.Parse(this.HiddenDurationTextBox.Text);
            }
            var message = new MessageDataModel { Users = userIds, Message = this.MessageTextBox.Text, DisplayDuration = display, HiddenDuration = hidden};
            foreach (var device in this.deviceList)
            {
                if (device.IsChecked)
                {
                    await this.serverManager.SetMessageAsyncTask(device.Name, message);
                }
            }
        }

        private async void DeviceListBox_OnLoaded(object sender, RoutedEventArgs e)
        {
            var devices = await this.serverManager.GetStatusAsyncTask();
            foreach (var device in devices)
            {
                this.deviceList.Add(new DeviceListBoxModel(device.TerminalName, false));
            }
        }
    }
}
