﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="RemoteAuthWindow.xaml.cs" company="Palizafzar">
//   Author : Mohammad Habibzadeh
// </copyright>
// <summary>
//   Interaction logic for remote authentication
// </summary>
// --------------------------------------------------------------------------------------------------------------------

namespace PalizTiara.Server
{
    using System;
    using System.Collections.ObjectModel;
    using System.Windows;

    using PalizTiara.Api;
    using PalizTiara.Api.CallBacks;
    using PalizTiara.Api.Helpers;
    using PalizTiara.Api.Models;

    /// <summary>
    /// Interaction logic for remote authentication
    /// </summary>
    public partial class RemoteAuthWindow
    {
        private readonly TiaraServerManager serverManager;

        private readonly ObservableCollection<RemoteAuthViewModel> collection = new ObservableCollection<RemoteAuthViewModel>();

        public RemoteAuthWindow(TiaraServerManager serverManager)
        {
            this.InitializeComponent();
            this.serverManager = serverManager;
            this.RemoteAuthRequestsDataGrid.DataContext = this.collection;
        }


        protected override void OnClosed(EventArgs e)
        {
            this.serverManager.RemoteAuthUserInfoRequestEvent -= this.ServerManagerOnRemoteAuthUserInfoRequestEvent;
            this.serverManager.RemoteAuthCardVerifyEvent -= this.ServerManagerOnRemoteAuthCardVerifyEvent;
            this.serverManager.RemoteAuthPasswordVerifyEvent -= this.ServerManagerOnRemoteAuthPasswordVerifyEvent;
            this.serverManager.RemoteAuthFingerprintVerifyEvent -= this.ServerManagerOnRemoteAuthFingerprintVerifyEvent;
            this.serverManager.RemoteAuthFaceVerifyEvent -= this.ServerManagerOnRemoteAuthFaceVerifyEvent;
            this.serverManager.RemoteAuthAdminExistRequestEvent -= this.ServerManagerOnRemoteAuthAdminExistRequestEvent;
            base.OnClosed(e);
        }

        private void RemoteAuthDockPanel_OnLoaded(object sender, RoutedEventArgs e)
        {
            this.serverManager.RemoteAuthUserInfoRequestEvent += this.ServerManagerOnRemoteAuthUserInfoRequestEvent;
            this.serverManager.RemoteAuthCardVerifyEvent += this.ServerManagerOnRemoteAuthCardVerifyEvent;
            this.serverManager.RemoteAuthPasswordVerifyEvent += this.ServerManagerOnRemoteAuthPasswordVerifyEvent;
            this.serverManager.RemoteAuthFingerprintVerifyEvent += this.ServerManagerOnRemoteAuthFingerprintVerifyEvent;
            this.serverManager.RemoteAuthFaceVerifyEvent += this.ServerManagerOnRemoteAuthFaceVerifyEvent;
            this.serverManager.RemoteAuthAdminExistRequestEvent += this.ServerManagerOnRemoteAuthAdminExistRequestEvent;
        }

        private async void ServerManagerOnRemoteAuthUserInfoRequestEvent(object sender, UserActionEventArgs args)
        {
            if (args?.UserId != null && !string.IsNullOrEmpty(args.TerminalName))
            {
                this.RemoteAuthRequestsDataGrid.Dispatcher.Invoke(
                    () =>
                    {
                        this.collection.Add(new RemoteAuthViewModel(args.UserId.UserId, 0, string.Empty, null, null, args.TerminalName));
                    });
                await this.serverManager.RemoteAuthUserInformationAsyncTask(
                    args.TerminalName,
                    new RemoteAuthUserInfoModel(
                        540,
                        "Habibzadeh",
                        null,
                        7,
                        1,
                        false,
                        false,
                        false,
                        StaticHelpers.GetEpochTime(DateTime.Now)),
                    false);
            }
        }

        private async void ServerManagerOnRemoteAuthAdminExistRequestEvent(object sender)
        {
            var deviceSender = (DeviceSender)sender;
            await this.serverManager.RemoteAuthAdminExistenceAsyncTask(deviceSender.TerminalName, true);
        }

        private async void ServerManagerOnRemoteAuthFaceVerifyEvent(object sender, RemoteAuthRequestEventArgs args)
        {
            if (args?.RemoteAuthRequestData != null && !string.IsNullOrEmpty(args.TerminalName))
            {
                this.RemoteAuthRequestsDataGrid.Dispatcher.Invoke(
                    () =>
                        {
                            this.collection.Add(new RemoteAuthViewModel(args.RemoteAuthRequestData.UserId, args.RemoteAuthRequestData.Card, args.RemoteAuthRequestData.Password, args.RemoteAuthRequestData.Face, args.RemoteAuthRequestData.Fingerprint, args.TerminalName));
                        });
                await this.serverManager.RemoteAuthFaceVerifyAsyncTask(args.TerminalName, new RemoteAuthResponseContainer(args.RemoteAuthRequestData.UserId, true));
            }
        }

        private async void ServerManagerOnRemoteAuthFingerprintVerifyEvent(object sender, RemoteAuthRequestEventArgs args)
        {
            if (args?.RemoteAuthRequestData != null && !string.IsNullOrEmpty(args.TerminalName))
            {
                var message = new MessageDataModel { Users = new long[] { 540 }, Message = "what the f", DisplayDuration = 2, HiddenDuration = 0 };
                await this.serverManager.SetMessageAsyncTask(args.TerminalName, message);
                this.RemoteAuthRequestsDataGrid.Dispatcher.Invoke(
                    () =>
                    {
                        this.collection.Add(new RemoteAuthViewModel(args.RemoteAuthRequestData.UserId, args.RemoteAuthRequestData.Card, args.RemoteAuthRequestData.Password, args.RemoteAuthRequestData.Face, args.RemoteAuthRequestData.Fingerprint, args.TerminalName));
                    });
                await this.serverManager.RemoteAuthFingerprintVerifyAsyncTask(args.TerminalName, new RemoteAuthResponseContainer(540, true));
            }
        }

        private async void ServerManagerOnRemoteAuthPasswordVerifyEvent(object sender, RemoteAuthRequestEventArgs args)
        {
            if (args?.RemoteAuthRequestData != null && !string.IsNullOrEmpty(args.TerminalName))
            {
                this.RemoteAuthRequestsDataGrid.Dispatcher.Invoke(
                    () =>
                    {
                        this.collection.Add(new RemoteAuthViewModel(args.RemoteAuthRequestData.UserId, args.RemoteAuthRequestData.Card, args.RemoteAuthRequestData.Password, args.RemoteAuthRequestData.Face, args.RemoteAuthRequestData.Fingerprint, args.TerminalName));
                    });
                await this.serverManager.RemoteAuthPasswordVerifyAsyncTask(args.TerminalName, new RemoteAuthResponseContainer(args.RemoteAuthRequestData.UserId, true));
            }
        }

        private async void ServerManagerOnRemoteAuthCardVerifyEvent(object sender, RemoteAuthRequestEventArgs args)
        {
            if (args?.RemoteAuthRequestData != null && !string.IsNullOrEmpty(args.TerminalName))
            {
                this.RemoteAuthRequestsDataGrid.Dispatcher.Invoke(
                    () =>
                    {
                        this.collection.Add(new RemoteAuthViewModel(args.RemoteAuthRequestData.UserId, args.RemoteAuthRequestData.Card, args.RemoteAuthRequestData.Password, args.RemoteAuthRequestData.Face, args.RemoteAuthRequestData.Fingerprint, args.TerminalName));
                    });
                await this.serverManager.RemoteAuthCardVerifyAsyncTask(args.TerminalName, new RemoteAuthResponseContainer(540, true));
            }
        }

        private class RemoteAuthViewModel : RemoteAuthRequestContainer
        {
            public RemoteAuthViewModel()
            {
            }

            public RemoteAuthViewModel(long userId, long card, string password, byte[] face, byte[] fingerprint, string terminalName)
                : base(userId, card, password, face, fingerprint)
            {
                this.TerminalName = terminalName;
            }

            public string TerminalName { get; set; }
        }
    }
}
