﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="TextBlockTraceListener.cs" company="Palizafzar">
//   Author: Mohammad Habibzadeh
// </copyright>
// <summary>
//   Defines the TextBlockTraceListener type.
// </summary>
// --------------------------------------------------------------------------------------------------------------------

namespace PalizTiara.Server
{
    using System.Diagnostics;
    using System.Windows.Controls;

    public class TextBlockTraceListener : TraceListener
    {
        private readonly TextBlock textBlock;

        public TextBlockTraceListener(TextBlock txtBox)
        {
            this.textBlock = txtBox;
        }

        public override void Write(string message)
        {
            this.textBlock?.Dispatcher.Invoke(() =>
            {
                this.textBlock.Text += message;
            });

        }

        public override void WriteLine(string message)
        {
            this.Write(message + "\r\n");
        }
    }
}