﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="UserInfoSummaryWindow.xaml.cs" company="Palizafzar">
//   Author : Mohammad Habibzadeh
// </copyright>
// <summary>
//   Interaction logic for UserInfoSummaryWindow.xaml
// </summary>
// --------------------------------------------------------------------------------------------------------------------

namespace PalizTiara.Server
{
    using System;
    using System.Collections.ObjectModel;
    using System.Windows;

    using PalizTiara.Api;
    using PalizTiara.Api.CallBacks;
    using PalizTiara.Api.Models;
    using PalizTiara.Server.ViewModel;

    /// <summary>
    /// Interaction logic for UserInfoSummaryWindow.xaml
    /// </summary>
    public partial class UserInfoSummaryWindow : Window
    {
        private readonly TiaraServerManager serverManager;
        private readonly ObservableCollection<DeviceListBoxModel> deviceList = new ObservableCollection<DeviceListBoxModel>();
        private readonly ObservableCollection<UserInfoSummaryModel> userInformations = new ObservableCollection<UserInfoSummaryModel>();

        public UserInfoSummaryWindow(TiaraServerManager serverManager)
        {
            this.InitializeComponent();
            this.serverManager = serverManager;
            this.DeviceListBox.ItemsSource = this.deviceList;
            this.UserInfoSummaryGrid.ItemsSource = this.userInformations;
            this.serverManager.MassUserInfoSummaryEvent += this.ServerManagerOnMassUserInfoSummaryEvent;
        }

        protected override void OnClosed(EventArgs e)
        {
            this.serverManager.MassUserInfoSummaryEvent -= this.ServerManagerOnMassUserInfoSummaryEvent;
            base.OnClosed(e);
        }

        private async void DeviceListBox_OnLoaded(object sender, RoutedEventArgs e)
        {
            var devices = await this.serverManager.GetStatusAsyncTask();
            foreach (var device in devices)
            {
                this.deviceList.Add(new DeviceListBoxModel(device.TerminalName, false));
            }
        }

        private void ServerManagerOnMassUserInfoSummaryEvent(object sender, MassUserInfoSummaryEventArgs args)
        {
            if (args?.Users?.UserInfoSummaryModels?.Length > 0)
            {
                this.UserInfoSummaryGrid.Dispatcher.Invoke(
                    () =>
                        {
                            foreach (var user in args.Users.UserInfoSummaryModels)
                            {
                                this.userInformations.Add(user);
                            }
                        });
            }
        }

        private async void GetUsersButton_OnClick(object sender, RoutedEventArgs e)
        {
            var from = int.Parse(this.FromTextBox.Text);            
            var to = int.Parse(this.ToTextBox.Text);
            if (from <= 0 || to <= 0)
            {
                return;
            }
            var request = new MassUserIdModel(from, to);
            foreach (var device in this.deviceList)
            {
                if (device.IsChecked)
                {
                    await this.serverManager.GetMassUserInfoSummaryTask(device.Name, request);
                }
            }
        }
    }
}
