﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="DeviceListBoxModel.cs" company="Palizafzar">
//   Author : Mohammad Habibzadeh
// </copyright>
// --------------------------------------------------------------------------------------------------------------------

namespace PalizTiara.Server.ViewModel
{
    using System.ComponentModel;
    using System.Runtime.CompilerServices;

    using PalizTiara.Server.Annotations;

    public class DeviceListBoxModel : INotifyPropertyChanged
    {
        private bool isChecked;

        private string name;

        public DeviceListBoxModel()
        {
        }

        public DeviceListBoxModel(string name, bool isChecked)
        {
            this.Name = name;
            this.IsChecked = isChecked;
        }

        public event PropertyChangedEventHandler PropertyChanged;

        public string Name
        {
            get
            {
                return this.name;
            }

            set
            {
                if (value == this.name)
                {
                    return;
                }
                this.name = value;
                this.OnPropertyChanged();
            }
        }

        public bool IsChecked
        {
            get
            {
                return this.isChecked;
            }

            set
            {
                if (value == this.isChecked)
                {
                    return;
                }
                this.isChecked = value;
                this.OnPropertyChanged();
            }
        }

        [NotifyPropertyChangedInvocator]
        protected virtual void OnPropertyChanged([CallerMemberName] string propertyName = null)
        {
            this.PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName));
        }
    }
}