﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="DeviceSerialListBoxModel.cs" company="Palizafzar">
//   Author : Mohammad Habibzadeh
// </copyright>
// <summary>
//   Defines the DeviceSerialListBoxModel type.
// </summary>
// --------------------------------------------------------------------------------------------------------------------

namespace PalizTiara.Server.ViewModel
{
    public class DeviceSerialListBoxModel : DeviceListBoxModel
    {
        private string serial;

        public DeviceSerialListBoxModel()
        {
        }

        public DeviceSerialListBoxModel(string name, string serial, bool isChecked)
            : base(name, isChecked)
        {
            this.Serial = serial;
        }

        public string Serial
        {
            get
            {
                return this.serial;
            }

            set
            {
                if (value == this.serial)
                {
                    return;
                }
                this.serial = value;
                this.OnPropertyChanged();
            }
        }
    }
}