﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="DeviceVersionListBoxModel.cs" company="Palizafzar">
//   Author : Mohammad Habibzadeh
// </copyright>
// --------------------------------------------------------------------------------------------------------------------

namespace PalizTiara.Server.ViewModel
{
    using System.ComponentModel;
    using System.Runtime.CompilerServices;

    using Annotations;

    public class DeviceVersionListBoxModel : INotifyPropertyChanged
    {
        private string name;

        private string version;

        private bool isChecked;

        public DeviceVersionListBoxModel()
        {
        }

        public DeviceVersionListBoxModel(string name, string version, bool isChecked)
        {
            this.Name = name;
            this.Version = version;
            this.IsChecked = isChecked;
        }

        public event PropertyChangedEventHandler PropertyChanged;

        public string Name
        {
            get
            {
                return this.name;
            }

            set
            {
                if (value == this.name)
                {
                    return;
                }
                this.name = value;
                this.OnPropertyChanged();
                this.OnPropertyChanged(nameof(this.FullName));
            }
        }

        public string Version
        {
            get
            {
                return this.version;
            }

            set
            {
                if (value == this.version)
                {
                    return;
                }
                this.version = value;
                this.OnPropertyChanged();
                this.OnPropertyChanged(nameof(this.FullName));
            }
        }

        public bool IsChecked
        {
            get
            {
                return this.isChecked;
            }

            set
            {
                if (value == this.isChecked)
                {
                    return;
                }
                this.isChecked = value;
                this.OnPropertyChanged();
            }
        }

        public string FullName
        {
            get
            {
                var result = string.Empty;
                if (!string.IsNullOrEmpty(this.Name))
                {
                    result += this.Name;
                }
                if (!string.IsNullOrEmpty(this.Version))
                {
                    result += " Ver." + this.Version;
                }
                return result;
            }
        }

        [NotifyPropertyChangedInvocator]
        protected virtual void OnPropertyChanged([CallerMemberName] string propertyName = null)
        {
            try
            {
                this.PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName));
            }
            catch{}
        }
    }
}