﻿// --------------------------------------------------------------------------------------------------------------------
// <copyright file="TiaraEncryptionManagerTest.cs" company="Palizafzar">
//   Author : Mohammad Habibzadeh
// </copyright>
// <summary>
//   Defines the TiaraEncryptionManagerTest type.
// </summary>
// --------------------------------------------------------------------------------------------------------------------

namespace PalizTiara.Tests
{
    using System.IO;
    using System.Threading.Tasks;

    using NUnit.Framework;

    using PalizTiara.Api;

    [TestFixture]
    public class TiaraEncryptionManagerTest
    {
        private readonly TiaraEncryptionManager tiaraEncryptionManager;

        public TiaraEncryptionManagerTest()
        {
            this.tiaraEncryptionManager = TiaraEncryptionManager.Instance;
        }

        [Test]
        public async Task LogFileDecryptionTest()
        {
            var source = @"D:\log.pgp";
            var dest = @"D:\log.txt";

            var sourceStream = new FileStream(source, FileMode.Open, FileAccess.Read);
            var destStream = new FileStream(dest, FileMode.OpenOrCreate, FileAccess.ReadWrite);

            var result = await this.tiaraEncryptionManager.DecryptLogStreamAsync(sourceStream, destStream);
            Assert.IsTrue(result);
            Assert.IsTrue(destStream.CanRead);
        }
    }
}